CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('1', '1', '2022-08-06 17:19:30', '2022-08-06 17:19:30', '<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->', 'Hello world!', '', 'publish', 'open', 'open', '', 'hello-world', '', '', '2022-08-06 17:19:30', '2022-08-06 17:19:30', '', '0', 'http://localhost:8888/test/wordpress/?p=1', '0', 'post', '', '1');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('2', '1', '2022-08-06 17:19:30', '2022-08-06 17:19:30', '<!-- wp:shortcode -->\n[cv-builder]\n<!-- /wp:shortcode -->', 'Sample Page', '', 'publish', 'closed', 'open', '', 'sample-page', '', '', '2022-08-06 17:53:48', '2022-08-06 17:53:48', '', '0', 'http://localhost:8888/test/wordpress/?page_id=2', '0', 'page', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('3', '1', '2022-08-06 17:19:30', '2022-08-06 17:19:30', '<!-- wp:heading --><h2>Who we are</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: http://localhost:8888/test/wordpress.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Comments</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Media</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Embedded content from other websites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Who we share your data with</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>How long we retain your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What rights you have over your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Where your data is sent</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p><!-- /wp:paragraph -->', 'Privacy Policy', '', 'draft', 'closed', 'open', '', 'privacy-policy', '', '', '2022-08-06 17:19:30', '2022-08-06 17:19:30', '', '0', 'http://localhost:8888/test/wordpress/?page_id=3', '0', 'page', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('4', '1', '2022-08-06 17:19:32', '2022-08-06 17:19:32', '', 'Default Kit', '', 'publish', 'closed', 'closed', '', 'default-kit', '', '', '2022-08-06 17:19:32', '2022-08-06 17:19:32', '', '0', 'http://localhost:8888/test/wordpress/?p=4', '0', 'elementor_library', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('7', '1', '2022-08-06 17:24:46', '2022-08-06 17:24:46', '{\"version\": 2, \"isGlobalStylesUserThemeJSON\": true }', 'Custom Styles', '', 'publish', 'closed', 'closed', '', 'wp-global-styles-twentytwentytwo', '', '', '2022-08-06 17:24:46', '2022-08-06 17:24:46', '', '0', 'http://localhost:8888/test/wordpress/?p=7', '0', 'wp_global_styles', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('9', '1', '2022-08-06 17:25:13', '2022-08-06 17:25:13', '<!-- wp:shortcode -->\n[cv-builder]\n<!-- /wp:shortcode -->\n\n<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like piña coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href=\"http://localhost:8888/test/wordpress/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2022-08-06 17:25:13', '2022-08-06 17:25:13', '', '2', 'http://localhost:8888/test/wordpress/?p=9', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('10', '1', '2022-08-06 17:26:11', '2022-08-06 17:26:11', '<!-- wp:shortcode -->\n[cv-builder]\n<!-- /wp:shortcode -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2022-08-06 17:26:11', '2022-08-06 17:26:11', '', '2', 'http://localhost:8888/test/wordpress/?p=10', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('12', '1', '2022-08-06 17:39:26', '2022-08-06 17:39:26', '<!-- wp:shortcode -->\n[cv-builder}\n<!-- /wp:shortcode -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2022-08-06 17:39:26', '2022-08-06 17:39:26', '', '2', 'http://localhost:8888/test/wordpress/?p=12', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('13', '1', '2022-08-06 17:39:37', '2022-08-06 17:39:37', '<!-- wp:shortcode -->\n[cv-builder]\n<!-- /wp:shortcode -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-revision-v1', '', '', '2022-08-06 17:39:37', '2022-08-06 17:39:37', '', '2', 'http://localhost:8888/test/wordpress/?p=13', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('20', '1', '2022-08-06 18:13:30', '2022-08-06 18:13:30', '<!-- wp:shortcode -->\n[cv-builder]\n<!-- /wp:shortcode -->', 'Sample Page', '', 'inherit', 'closed', 'closed', '', '2-autosave-v1', '', '', '2022-08-06 18:13:30', '2022-08-06 18:13:30', '', '2', 'http://localhost:8888/test/wordpress/?p=20', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('41', '1', '2022-10-13 22:53:51', '2022-10-13 22:53:51', '', 'Ride-invoice-from-Bolt', '', 'inherit', 'open', 'closed', '', 'ride-invoice-from-bolt', '', '', '2022-10-13 22:53:51', '2022-10-13 22:53:51', '', '0', 'http://localhost:8888/test/wordpress/wp-content/uploads/2022/10/Ride-invoice-from-Bolt.pdf', '0', 'attachment', 'application/pdf', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('44', '0', '2022-10-13 23:17:00', '2022-10-13 23:17:00', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont', '', '', '2022-10-13 23:17:00', '2022-10-13 23:17:00', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('45', '0', '2022-10-13 23:18:32', '2022-10-13 23:18:32', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-2', '', '', '2022-10-13 23:18:32', '2022-10-13 23:18:32', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-2/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('46', '0', '2022-10-13 23:20:26', '2022-10-13 23:20:26', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-3', '', '', '2022-10-13 23:20:26', '2022-10-13 23:20:26', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-3/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('47', '0', '2022-10-13 23:20:51', '2022-10-13 23:20:51', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-4', '', '', '2022-10-13 23:20:51', '2022-10-13 23:20:51', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-4/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('48', '0', '2022-10-13 23:24:54', '2022-10-13 23:24:54', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-5', '', '', '2022-10-13 23:24:54', '2022-10-13 23:24:54', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-5/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('49', '0', '2022-10-13 23:25:56', '2022-10-13 23:25:56', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-6', '', '', '2022-10-13 23:25:56', '2022-10-13 23:25:56', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-6/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('50', '0', '2022-10-13 23:27:20', '2022-10-13 23:27:20', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-7', '', '', '2022-10-13 23:27:20', '2022-10-13 23:27:20', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-7/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('51', '0', '2022-10-13 23:27:56', '2022-10-13 23:27:56', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-8', '', '', '2022-10-13 23:27:56', '2022-10-13 23:27:56', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-8/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('52', '0', '2022-10-13 23:28:26', '2022-10-13 23:28:26', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-9', '', '', '2022-10-13 23:28:26', '2022-10-13 23:28:26', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-9/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('53', '0', '2022-10-13 23:29:49', '2022-10-13 23:29:49', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-10', '', '', '2022-10-13 23:29:49', '2022-10-13 23:29:49', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-10/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('54', '0', '2022-10-13 23:31:02', '2022-10-13 23:31:02', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-11', '', '', '2022-10-13 23:31:02', '2022-10-13 23:31:02', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-11/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('55', '0', '2022-10-13 23:32:31', '2022-10-13 23:32:31', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-12', '', '', '2022-10-13 23:32:31', '2022-10-13 23:32:31', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-12/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('56', '0', '2022-10-13 23:35:18', '2022-10-13 23:35:18', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-13', '', '', '2022-10-13 23:35:18', '2022-10-13 23:35:18', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-13/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('57', '0', '2022-10-14 00:11:33', '2022-10-14 00:11:33', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-14', '', '', '2022-10-14 00:11:33', '2022-10-14 00:11:33', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-14/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('58', '0', '2022-10-14 00:12:45', '2022-10-14 00:12:45', '<!-- wp:html --><table id=\"table_r14q7hjpz\" class=\"resume_resume__1qhDM resume_page__hd1rl\"><tbody id=\"tbody_a71iyk3ka\" class=\"resume_tbody__7VLV1\"><tr id=\"tr_5sdv663kk\" class=\"resume_intro__dbma3\"><td id=\"td_w7w0rqsbm\" class=\"resume_left__NHhFq\"><div id=\"div_rm9ubheed\" class=\"resume_introWrapper__2V8wm\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td id=\"td_kklmhe613\" class=\"resume_right__lyRKy\"><div id=\"div_l8u8kjxqa\" class=\"resume_introWrapper__2V8wm\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr id=\"tr_3j4b7yt1z\" class=\"resume_content__pM6fk\"><td id=\"td_166lc9pqx\" class=\"resume_left__NHhFq\"><div id=\"div_1pznabm46\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td id=\"td_6w8bbyrno\" class=\"resume_right__lyRKy\"><div id=\"div_co9wfm20e\" class=\"resume_contentWrapper__ioRgb\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-15', '', '', '2022-10-14 00:12:45', '2022-10-14 00:12:45', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-15/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('59', '0', '2022-10-14 00:44:23', '2022-10-14 00:44:23', '<!-- wp:html --><table class=\"resume_resume__1qhDM resume_page__hd1rl\" id=\"table_r14q7hjpz\"><tbody class=\"resume_tbody__7VLV1\" id=\"tbody_a71iyk3ka\"><tr class=\"resume_intro__dbma3\" id=\"tr_5sdv663kk\"><td class=\"resume_left__NHhFq\" id=\"td_w7w0rqsbm\"><div class=\"resume_introWrapper__2V8wm\" id=\"div_rm9ubheed\"><div class=\"classic_imgContainer__IZr3V\"></div></div></td><td class=\"resume_right__lyRKy\" id=\"td_kklmhe613\"><div class=\"resume_introWrapper__2V8wm\" id=\"div_l8u8kjxqa\"><p class=\"resume_name__8xoKL\">Noah Delophont</p><p class=\"resume_title__09L4A\"></p></div></td></tr><tr class=\"resume_content__pM6fk\" id=\"tr_3j4b7yt1z\"><td class=\"resume_left__NHhFq\" id=\"td_166lc9pqx\"><div class=\"resume_contentWrapper__ioRgb\" id=\"div_1pznabm46\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">CONTACT ME AT</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">noah.delophont@gmail.com</p><p class=\"resume_listElt__jDA3a\">+33652722852</p><p class=\"resume_listElt__jDA3a\">Nationality: French</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">LANGUAGES</p><div class=\"resume_list__KpCdU\"><p class=\"resume_listElt__jDA3a\">French: Proficiency</p><p class=\"resume_listElt__jDA3a\">English: Proficiency</p><p class=\"resume_listElt__jDA3a\">German: Upper-Intermediate</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">SKILLS</p><div class=\"resume_list__KpCdU\"><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Leadership Skills</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Communication</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div></div></div><div class=\"classic_skill__HuOap\"><p class=\"resume_listElt__jDA3a classic_skillName__nmnGK\">Business Etiquette</p><div class=\"classic_ratingSection__KALUO\"><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb  classic_full__uE4t0\"></div><div class=\"classic_levelCircle__crIRb\"></div></div></div></div></div></div></td><td class=\"resume_right__lyRKy\" id=\"td_6w8bbyrno\"><div class=\"resume_contentWrapper__ioRgb\" id=\"div_co9wfm20e\"><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">PERSONAL PROFILE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementParagraph__B7-bY\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">WORK EXPERIENCE</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Founder &amp; CEO</p><p class=\"resume_elementInfo__yQscr\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a CV Plugin Builder that can be integrated on every website</li><li class=\"resume_elementParagraph__B7-bY\">Automated form creation by building a form creator tool</li><li class=\"resume_elementParagraph__B7-bY\">Created a html to pdf generator online</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">IT Project Manager</p><p class=\"resume_elementInfo__yQscr\">Job Squad  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li class=\"resume_elementParagraph__B7-bY\">Planned, organized, and integrated a custom made CV builder</li><li class=\"resume_elementParagraph__B7-bY\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Full Stack Web Developer</p><p class=\"resume_elementInfo__yQscr\">Kenmore Design  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Created a cloud-base CRM system for FOREX brokerage companies</li><li class=\"resume_elementParagraph__B7-bY\">Key features: contact management, email integration, file sharing</li><li class=\"resume_elementParagraph__B7-bY\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div class=\"resume_section__tfpa8\"><p class=\"resume_titleSection__8sIPq\">EDUCATION</p><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">Institut Mines-Télécom Business School</p><p class=\"resume_elementInfo__yQscr\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li class=\"resume_elementParagraph__B7-bY\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li class=\"resume_elementParagraph__B7-bY\">Major: International Marketing Strategy</li></ul></div><div class=\"resume_element__+Tyh2\"><p class=\"resume_elementTitle__FXxDE\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p class=\"resume_elementInfo__yQscr\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul class=\"resume_list__KpCdU\"><li class=\"resume_elementParagraph__B7-bY\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li class=\"resume_elementParagraph__B7-bY\">Member of Dièse, the student-run organisation of the school</li><li class=\"resume_elementParagraph__B7-bY\">Learned how to be a SCRUM master</li></ul></div></div><div class=\"resume_section__tfpa8 resume_element__+Tyh2\"><p class=\"resume_titleSection__8sIPq\">HOBBIES</p><p class=\"resume_elementParagraph__B7-bY\">Playing the Guitar and Singing</p><p class=\"resume_elementParagraph__B7-bY\">Watching documentaries</p></div></div><a class=\"resume_watermark__RXNw7\" href=\"https://www.cvplugin.comhttps://app.cvplugin.com/free/\" id=\"Link_x3ogmn7bx\">This plugin has been created for free with cvplugin.com</a></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-16', '', '', '2022-10-14 00:44:23', '2022-10-14 00:44:23', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-16/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('61', '1', '2022-10-26 11:16:39', '2022-10-26 11:16:39', '<!-- wp:paragraph -->\n<p>[gather-registration]</p>\n<!-- /wp:paragraph -->', 'Gather Registration', '', 'publish', 'closed', 'closed', '', 'gather-registration', '', '', '2022-10-26 11:16:50', '2022-10-26 11:16:50', '', '0', 'http://localhost:8888/test/wordpress/?page_id=61', '0', 'page', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('62', '1', '2022-10-26 11:16:39', '2022-10-26 11:16:39', '', 'Gather Registration', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2022-10-26 11:16:39', '2022-10-26 11:16:39', '', '61', 'http://localhost:8888/test/wordpress/?p=62', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('63', '1', '2022-10-26 11:16:50', '2022-10-26 11:16:50', '<!-- wp:paragraph -->\n<p>[gather-registration]</p>\n<!-- /wp:paragraph -->', 'Gather Registration', '', 'inherit', 'closed', 'closed', '', '61-revision-v1', '', '', '2022-10-26 11:16:50', '2022-10-26 11:16:50', '', '61', 'http://localhost:8888/test/wordpress/?p=63', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('64', '0', '2022-11-03 12:36:34', '2022-11-03 12:36:34', '<!-- wp:html -->@import url(\'https://fonts.googleapis.com/css2?family=Roboto+Flex:opsz,wght@8..144,100;8..144,200;8..144,300;8..144,400;8..144,500;8..144,600;8..144,700;8..144,800;8..144,900;8..144,1000&amp;display=swap\')<table class=\"resume page\" id=\"table_r14q7hjpz\" style=\", sans-serif;height: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border-collapse: collapse;background-color: white;overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><tbody class=\"tbody\" id=\"tbody_a71iyk3ka\" style=\"height: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><tr class=\"intro\" id=\"tr_5sdv663kk\" style=\"overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><td class=\"left\" id=\"td_w7w0rqsbm\" style=\"text-align: center;color: white;width: 36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"introWrapper\" id=\"div_rm9ubheed\" style=\"height: 80pt\"><div></div></div></td><td class=\"right\" id=\"td_kklmhe613\" style=\"width: 64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"introWrapper\" id=\"div_l8u8kjxqa\" style=\"height: 80pt\"><p style=\"padding-top: 50pt;padding-left: 6{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};letter-spacing: 2px;font-weight: 700;font-size: 30pt\">Noah Delophont</p><p style=\"letter-spacing: 4px;font-weight: 400;font-size: 24pt\"></p></div></td></tr><tr class=\"content\" id=\"tr_3j4b7yt1z\" style=\"overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><td class=\"left\" id=\"td_166lc9pqx\" style=\"text-align: center;color: white;width: 36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"contentWrapper\" id=\"div_1pznabm46\" style=\"height: 760pt\"><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">CONTACT ME AT</p><div style=\"margin: 0px\"><p style=\"line-height: 1;padding: 2px;margin: 0px\">noah.delophont@gmail.com</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">+33652722852</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">Nationality: French</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">LANGUAGES</p><div style=\"margin: 0px\"><p style=\"line-height: 1;padding: 2px;margin: 0px\">French: Proficiency</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">English: Proficiency</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">German: Upper-Intermediate</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">SKILLS</p><div style=\"margin: 0px\"><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Leadership Skills</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div></div></div><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Communication</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div></div></div><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Business Etiquette</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white\"></div></div></div></div></div></div></td><td class=\"right\" id=\"td_6w8bbyrno\" style=\"width: 64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"contentWrapper\" id=\"div_co9wfm20e\" style=\"height: 760pt\"><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">PERSONAL PROFILE</p><div style=\"padding-bottom: 10pt\"><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">WORK EXPERIENCE</p><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Founder &amp; CEO</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a CV Plugin Builder that can be integrated on every website</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Automated form creation by building a form creator tool</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a html to pdf generator online</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">IT Project Manager</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Job Squad  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Planned, organized, and integrated a custom made CV builder</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Full Stack Web Developer</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Kenmore Design  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a cloud-base CRM system for FOREX brokerage companies</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Key features: contact management, email integration, file sharing</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">EDUCATION</p><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Institut Mines-Télécom Business School</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Major: International Marketing Strategy</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Member of Dièse, the student-run organisation of the school</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Learned how to be a SCRUM master</li></ul></div></div><div style=\"padding: 7.5pt 22.5pt 10pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">HOBBIES</p><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Playing the Guitar and Singing</p><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Watching documentaries</p></div></div><a class=\"watermark\" href=\"\" id=\"a_x3ogmn7bx\" style=\"margin-top: -20px;font-size: 12px\">This plugin has been created for free with cvplugin.com</a></td></tr></tbody></table><!-- /wp:html -->', 'ResumeNoahDelophont', '', 'publish', 'closed', 'closed', '', 'resumenoahdelophont-17', '', '', '2022-11-03 12:36:34', '2022-11-03 12:36:34', '', '0', 'http://localhost:8888/test/wordpress/documents/resumenoahdelophont-17/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('66', '1', '2022-11-03 12:42:17', '2022-11-03 12:42:17', '<!-- wp:html -->\n@import url(\'https://fonts.googleapis.com/css2?family=Roboto+Flex:opsz,wght@8..144,100;8..144,200;8..144,300;8..144,400;8..144,500;8..144,600;8..144,700;8..144,800;8..144,900;8..144,1000&amp;display=swap\')<table class=\"resume page\" id=\"table_r14q7hjpz\" style=\", sans-serif;height: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border-collapse: collapse;background-color: white;overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><tbody class=\"tbody\" id=\"tbody_a71iyk3ka\" style=\"height: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><tr class=\"intro\" id=\"tr_5sdv663kk\" style=\"overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><td class=\"left\" id=\"td_w7w0rqsbm\" style=\"text-align: center;color: white;width: 36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"introWrapper\" id=\"div_rm9ubheed\" style=\"height: 80pt\"><div></div></div></td><td class=\"right\" id=\"td_kklmhe613\" style=\"width: 64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"introWrapper\" id=\"div_l8u8kjxqa\" style=\"height: 80pt\"><p style=\"padding-top: 50pt;padding-left: 6{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};letter-spacing: 2px;font-weight: 700;font-size: 30pt\">Noah Delophont</p><p style=\"letter-spacing: 4px;font-weight: 400;font-size: 24pt\"></p></div></td></tr><tr class=\"content\" id=\"tr_3j4b7yt1z\" style=\"overflow: hidden;width: 100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><td class=\"left\" id=\"td_166lc9pqx\" style=\"text-align: center;color: white;width: 36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"contentWrapper\" id=\"div_1pznabm46\" style=\"height: 760pt\"><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">CONTACT ME AT</p><div style=\"margin: 0px\"><p style=\"line-height: 1;padding: 2px;margin: 0px\">noah.delophont@gmail.com</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">+33652722852</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">Nationality: French</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">LANGUAGES</p><div style=\"margin: 0px\"><p style=\"line-height: 1;padding: 2px;margin: 0px\">French: Proficiency</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">English: Proficiency</p><p style=\"line-height: 1;padding: 2px;margin: 0px\">German: Upper-Intermediate</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">SKILLS</p><div style=\"margin: 0px\"><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Leadership Skills</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div></div></div><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Communication</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div></div></div><div><p style=\"line-height: 1;padding: 0px;margin: 0px;width: 110pt\">Business Etiquette</p><div style=\"margin-left: auto;margin-right: auto;width: 55pt\"><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white;background-color: white\"></div><div style=\"width: 5pt;height: 5pt;margin-left: 1pt;margin-right: 1pt;border-radius: 5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98};border: 1px solid white\"></div></div></div></div></div></div></td><td class=\"right\" id=\"td_6w8bbyrno\" style=\"width: 64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}\"><div class=\"contentWrapper\" id=\"div_co9wfm20e\" style=\"height: 760pt\"><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">PERSONAL PROFILE</p><div style=\"padding-bottom: 10pt\"><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Hello, I am Noah Delophont, the founder of Web Services Outsourcing. CV Plugin is a product developped by Web Services Outsourcing.</p></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">WORK EXPERIENCE</p><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Founder &amp; CEO</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Web Services Outsourcing  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a CV Plugin Builder that can be integrated on every website</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Automated form creation by building a form creator tool</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a html to pdf generator online</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">IT Project Manager</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Job Squad  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created automated email campaigns and increased recovered candidate rate by more than 50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Planned, organized, and integrated a custom made CV builder</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">SEO: improved Google results ranking and reached the top 3 results on the Danish market</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Full Stack Web Developer</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Kenmore Design  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Created a cloud-base CRM system for FOREX brokerage companies</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Key features: contact management, email integration, file sharing</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Used Nodejs, React and other javascript frameworks</li></ul></div></div><div style=\"padding: 7.5pt 22.5pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">EDUCATION</p><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">Institut Mines-Télécom Business School</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Master of Business Administration and Management  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Half year exchange with Warsaw University of Technology (WUT), Poland</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Master thesis: The adoption of e-commerce by small and medium businesses</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Major: International Marketing Strategy</li></ul></div><div style=\"padding-bottom: 10pt\"><p style=\"padding-bottom: 2px;font-weight: 700;font-size: 12pt;line-height: 1;margin: 0px\">ENSIIE - École Nationale Supérieure d\'Informatique pour l\'Industrie et l\'Entreprise</p><p style=\"padding-bottom: 1px;font-weight: normal;font-size: 11pt;line-height: 1;margin: 0px\">Software Engineering Degree  | 10/2022  -  10/2022</p><ul style=\"margin: 0px\"><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Third prize of the “Challenge Project” which is one of the biggest entrepreneurship events</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Member of Dièse, the student-run organisation of the school</li><li style=\"line-height: 1;font-size: 10pt;margin: 0px\">Learned how to be a SCRUM master</li></ul></div></div><div style=\"padding: 7.5pt 22.5pt 10pt;margin: 0px\"><p style=\"letter-spacing: 4px;font-weight: 700;font-size: 14pt;line-height: 1;margin: 0px\">HOBBIES</p><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Playing the Guitar and Singing</p><p style=\"line-height: 1;font-size: 10pt;margin: 0px\">Watching documentaries</p></div></div><a class=\"watermark\" href=\"\" id=\"a_x3ogmn7bx\" style=\"margin-top: -20px;font-size: 12px\">This plugin has been created for free with cvplugin.com</a></td></tr></tbody></table>\n<!-- /wp:html -->', 'ResumeNoahDelophont', '', 'inherit', 'closed', 'closed', '', '64-autosave-v1', '', '', '2022-11-03 12:42:17', '2022-11-03 12:42:17', '', '64', 'http://localhost:8888/test/wordpress/?p=66', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('67', '0', '2022-11-03 12:48:00', '2022-11-03 12:48:00', '<!-- wp:html --><div id=\"cv-container\"></div>const iframe = document.createElement(\"iframe\");iframe.src = \'data:text/html;charset=utf-8,\' + \'{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cstyle{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}40import+url{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}28{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}27https{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ffonts.googleapis.com{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fcss2{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ffamily{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3DRoboto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2BFlex{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Aopsz{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Cwght{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}408..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C200{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C300{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C400{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C500{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C600{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C800{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C900{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B8..144{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C1000{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}26display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Dswap{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}27{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fstyle{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctable+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22resume+page{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22table_r14q7hjpz{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22font-family{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}26quot{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3BRoboto+Flex{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}26quot{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+sans-serif{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+rgb{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2868{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+68{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-collapse{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+collapse{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+overflow{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+hidden{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctbody+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22tbody{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22tbody_a71iyk3ka{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctr+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22intro{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22tr_5sdv663kk{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22overflow{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+hidden{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctd+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22td_w7w0rqsbm{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22text-align{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+center{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+rgb{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2851{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+83{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+132{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22introWrapper{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22div_rm9ubheed{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+80pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftd{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctd+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22td_kklmhe613{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+rgb{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2868{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+68{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22introWrapper{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22div_l8u8kjxqa{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+80pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-top{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+50pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+6{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+30pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EBlaise+Delophont{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+400{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+24pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftd{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftr{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctr+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22content{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22tr_3j4b7yt1z{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22overflow{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+hidden{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+100{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctd+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22td_166lc9pqx{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22text-align{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+center{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+36{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+rgb{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2851{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+83{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+132{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22contentWrapper{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22div_1pznabm46{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+760pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECONTACT+ME+AT{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Enoah.delophont{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}40gmail.com{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2B33652722852{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ENationality{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+French{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ELANGUAGES{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EFrench{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+Proficiency{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EEnglish{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+Proficiency{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EGerman{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+Upper-Intermediate{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ESKILLS{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+110pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ELeadership+Skills{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+55pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+110pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECommunication{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+55pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+110pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EBusiness+Etiquette{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+auto{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+55pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+background-color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-left{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin-right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border-radius{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+5{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+display{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+inline-block{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+border{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px+solid+white{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftd{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ctd+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22right{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22td_6w8bbyrno{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22color{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+rgb{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2868{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+68{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+width{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+64{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22contentWrapper{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22div_co9wfm20e{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+760pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EPERSONAL+PROFILE{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EHello{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+I+am+Noah+Delophont{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+the+founder+of+Web+Services+Outsourcing.+CV+Plugin+is+a+product+developped+by+Web+Services+Outsourcing.{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EWORK+EXPERIENCE{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EFounder+{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}26amp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+CEO{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+normal{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+11pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EWeb+Services+Outsourcing++{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}7C+10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022++-++10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cul+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECreated+a+CV+Plugin+Builder+that+can+be+integrated+on+every+website{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EAutomated+form+creation+by+building+a+form+creator+tool{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECreated+a+html+to+pdf+generator+online{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ful{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EIT+Project+Manager{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+normal{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+11pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EJob+Squad++{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}7C+10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022++-++10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cul+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECreated+automated+email+campaigns+and+increased+recovered+candidate+rate+by+more+than+50{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}25{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EPlanned{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+organized{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+and+integrated+a+custom+made+CV+builder{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ESEO{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+improved+Google+results+ranking+and+reached+the+top+3+results+on+the+Danish+market{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ful{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EFull+Stack+Web+Developer{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+normal{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+11pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EKenmore+Design++{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}7C+10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022++-++10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cul+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ECreated+a+cloud-base+CRM+system+for+FOREX+brokerage+companies{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EKey+features{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+contact+management{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+email+integration{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+file+sharing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EUsed+Nodejs{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+React+and+other+javascript+frameworks{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ful{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EEDUCATION{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EInstitut+Mines-T{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}C3{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}A9l{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}C3{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}A9com+Business+School{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+normal{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+11pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EMaster+of+Business+Administration+and+Management++{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}7C+10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022++-++10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cul+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EHalf+year+exchange+with+Warsaw+University+of+Technology+{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}28WUT{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}29{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+Poland{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EMaster+thesis{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+The+adoption+of+e-commerce+by+small+and+medium+businesses{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EMajor{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+International+Marketing+Strategy{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ful{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+2px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EENSIIE+-+{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}C3{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}89cole+Nationale+Sup{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}C3{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}A9rieure+d{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}27Informatique+pour+l{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}27Industrie+et+l{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}27Entreprise{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding-bottom{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+normal{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+11pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ESoftware+Engineering+Degree++{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}7C+10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022++-++10{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2F2022{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cul+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EThird+prize+of+the+{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}E2{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}80{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}9CChallenge+Project{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}E2{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}80{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}9D+which+is+one+of+the+biggest+entrepreneurship+events{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EMember+of+Di{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}C3{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}A8se{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2C+the+student-run+organisation+of+the+school{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cli+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3ELearned+how+to+be+a+SCRUM+master{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fli{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ful{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cdiv+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22padding{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+7.5pt+22.5pt+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22letter-spacing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+4px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-weight{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+700{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+14pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EHOBBIES{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EPlaying+the+Guitar+and+Singing{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Cp+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22line-height{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+1{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+10pt{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+margin{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+0px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EWatching+documentaries{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fp{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fdiv{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3Ca+class{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22watermark{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+href{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+text{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22This+plugin+has+been+created+for+free+with+cvplugin.com{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+id{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22a_x3ogmn7bx{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22+style{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3D{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22margin-top{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+-20px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+font-size{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+12px{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B+position{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3A+absolute{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3B{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}22{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3EThis+plugin+has+been+created+for+free+with+cvplugin.com{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Fa{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftd{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftr{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftbody{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3C{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}2Ftable{370c7ad13e174a2dc5b6f6a6ce6d0d250984f61a6627e318dd7f7364a83f5e98}3E\';<!-- /wp:html -->', 'ResumeBlaiseDelophont', '', 'publish', 'closed', 'closed', '', 'resumeblaisedelophont', '', '', '2022-11-03 12:48:00', '2022-11-03 12:48:00', '', '0', 'http://localhost:8888/test/wordpress/documents/resumeblaisedelophont/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('68', '0', '2022-11-03 12:52:44', '2022-11-03 12:52:44', '<!-- wp:html --><object></object><!-- /wp:html -->', 'ResumeBlaiseRosyan', '', 'publish', 'closed', 'closed', '', 'resumeblaiserosyan', '', '', '2022-11-03 12:52:44', '2022-11-03 12:52:44', '', '0', 'http://localhost:8888/test/wordpress/documents/resumeblaiserosyan/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('69', '1', '2022-11-03 13:07:15', '2022-11-03 13:07:15', '<!-- wp:html -->\n<object></object>\n<!-- /wp:html -->\n\n<!-- wp:html -->\n<iframe src=\"http://localhost:8888/test/wordpress/wp-content/uploads/pdf-builder/2022/11/03/6363b99c57803.pdf\"></iframe>\n<!-- /wp:html -->', 'ResumeBlaiseRosyan', '', 'inherit', 'closed', 'closed', '', '68-autosave-v1', '', '', '2022-11-03 13:07:15', '2022-11-03 13:07:15', '', '68', 'http://localhost:8888/test/wordpress/?p=69', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('70', '0', '2022-11-03 13:12:32', '2022-11-03 13:12:32', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Blaise Rosyan', '', 'publish', 'closed', 'closed', '', 'blaise-rosyan', '', '', '2022-11-03 13:12:32', '2022-11-03 13:12:32', '', '0', 'http://localhost:8888/test/wordpress/documents/blaise-rosyan/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('71', '0', '2022-11-03 13:34:07', '2022-11-03 13:34:07', '<!-- wp:html --><object></object><!-- /wp:html -->', 'New Test', '', 'publish', 'closed', 'closed', '', 'new-test', '', '', '2022-11-03 13:34:07', '2022-11-03 13:34:07', '', '0', 'http://localhost:8888/test/wordpress/documents/new-test/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('72', '0', '2022-11-03 14:03:42', '2022-11-03 14:03:42', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont', '', '', '2022-11-03 14:03:42', '2022-11-03 14:03:42', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('73', '0', '2022-11-03 14:05:56', '2022-11-03 14:05:56', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-2', '', '', '2022-11-03 14:05:56', '2022-11-03 14:05:56', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-2/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('74', '0', '2022-11-03 14:07:42', '2022-11-03 14:07:42', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-3', '', '', '2022-11-03 14:07:42', '2022-11-03 14:07:42', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-3/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('75', '0', '2022-11-03 14:11:50', '2022-11-03 14:11:50', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-4', '', '', '2022-11-03 14:11:50', '2022-11-03 14:11:50', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-4/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('76', '0', '2022-11-03 14:12:50', '2022-11-03 14:12:50', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-5', '', '', '2022-11-03 14:12:50', '2022-11-03 14:12:50', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-5/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('77', '0', '2022-11-03 14:14:59', '2022-11-03 14:14:59', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-6', '', '', '2022-11-03 14:14:59', '2022-11-03 14:14:59', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-6/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('78', '0', '2022-11-03 14:15:41', '2022-11-03 14:15:41', '', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-7', '', '', '2022-11-03 14:15:41', '2022-11-03 14:15:41', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-7/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('79', '0', '2022-11-03 14:16:29', '2022-11-03 14:16:29', '', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-8', '', '', '2022-11-03 14:16:29', '2022-11-03 14:16:29', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-8/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('80', '0', '2022-11-03 14:20:39', '2022-11-03 14:20:39', '', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-9', '', '', '2022-11-03 14:20:39', '2022-11-03 14:20:39', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-9/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('81', '0', '2022-11-03 14:23:08', '2022-11-03 14:23:08', '<!-- wp:html --><object></object><!-- /wp:html -->', 'Noah Delophont', '', 'publish', 'closed', 'closed', '', 'noah-delophont-10', '', '', '2022-11-03 14:23:08', '2022-11-03 14:23:08', '', '0', 'http://localhost:8888/test/wordpress/documents/noah-delophont-10/', '0', 'document', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('86', '1', '2023-08-08 07:56:25', '2023-08-08 07:56:25', '<!-- wp:paragraph -->\n<p>Test Page content</p>\n<!-- /wp:paragraph -->', 'Test Page', '', 'publish', 'closed', 'closed', '', 'test-page', '', '', '2023-08-09 07:10:18', '2023-08-09 07:10:18', '', '0', 'http://localhost:8888/test/wordpress/?page_id=86', '0', 'page', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('87', '1', '2023-08-08 07:56:25', '2023-08-08 07:56:25', '<!-- wp:paragraph -->\n<p>Test Page content</p>\n<!-- /wp:paragraph -->', 'Test Page', '', 'inherit', 'closed', 'closed', '', '86-revision-v1', '', '', '2023-08-08 07:56:25', '2023-08-08 07:56:25', '', '86', 'http://localhost:8888/test/wordpress/?p=87', '0', 'revision', '', '0');
INSERT INTO `wp_posts` (`ID`, `post_author`, `post_date`, `post_date_gmt`, `post_content`, `post_title`, `post_excerpt`, `post_status`, `comment_status`, `ping_status`, `post_password`, `post_name`, `to_ping`, `pinged`, `post_modified`, `post_modified_gmt`, `post_content_filtered`, `post_parent`, `guid`, `menu_order`, `post_type`, `post_mime_type`, `comment_count`) VALUES ('88', '1', '2023-08-08 08:08:46', '0000-00-00 00:00:00', '', 'Auto Draft', '', 'auto-draft', 'open', 'open', '', '', '', '', '2023-08-08 08:08:46', '0000-00-00 00:00:00', '', '0', 'http://localhost:8888/test/wordpress/?p=88', '0', 'post', '', '0');
