<?php

function sendAPIRequest($url, $body, $bearer = null) {
	$curl = curl_init();
	$params = array(
		CURLOPT_URL =>  $url,
		CURLOPT_POST => true,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_NOBODY => false,
		CURLOPT_HTTPHEADER => array(
			"accept: */*",
			"cache-control: no-cache",
			"accept-encoding: gzip, deflate",
			"user-agent: PostmanRuntime/7.29.2"
		),
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_POSTFIELDS => http_build_query($body),
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
	);

	if ($bearer !== null) {
		$params[CURLOPT_HTTPHEADER][] = "Authorization: Bearer ${bearer}";
	}

	curl_setopt_array($curl, $params);

	$response = curl_exec($curl);
	$err = curl_error($curl);
 
	curl_close($curl);

	if ($err) {
		return $err;
	} else {
		$response = json_decode($response, true);
		return $response;
	}
}
