<?php

function post_curl_request($url, $body, $bearer = null) {
	$postjson = json_encode($body);
	$curl = curl_init();
	$params = array(
		CURLOPT_URL =>  $url,
		CURLOPT_POST => true,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_NOBODY => false,
		CURLOPT_HTTPHEADER => array(
			"accept: */*",
			"cache-control: no-cache",
			"content-type: application/json",
			"accept-encoding: gzip, deflate",
			"user-agent: PostmanRuntime/7.29.2"
		),
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_POSTFIELDS => $postjson,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1
	);

	if ($bearer !== null) {
		$params[CURLOPT_HTTPHEADER][] = "Authorization: Bearer ${bearer}";
	}

	curl_setopt_array($curl, $params);

	$response = curl_exec($curl);
	$err = curl_error($curl);
 
	curl_close($curl);

	if ($err) {
		return $err;
	} else {
		$response = json_decode($response, true);
		return $response;
	}
}


function get_curl_request($url, $bearer = null) {
	$curl = curl_init();
	$params = array(
		CURLOPT_URL =>  $url,
		CURLOPT_TIMEOUT => 30,
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_CUSTOMREQUEST => 'GET',
		CURLOPT_RETURNTRANSFER => true,
	);

	if ($bearer !== null) {
		$params[CURLOPT_HTTPHEADER][] = "Authorization: Bearer ${bearer}";
	}

	curl_setopt_array($curl, $params);

	$response = curl_exec($curl);
	$err = curl_error($curl);
	curl_close($curl);

	if ($err) {
		return $err;
	} else {
		$response = json_decode($response, true);
		return $response;
	}
}
