<?php

require_once dirname( __FILE__ ) . '/helpers.php';
require_once dirname( __FILE__ ) . '/API/index.php';

function register_webhook_route() {
	//http://example.com/wp-json/gather/add/user
	register_rest_route('gather/add', '/user', [
		'methods' => 'POST',
		'callback' => 'gather_register_webhook',
		'permission_callback' => '__return_true',
		'args' => [
			'email' => [
				'required' => true,
				'validate_callback' => 'is_email',
				'sanitize_callback' => 'input_cleaner'
			],
			'country' => [
				'required' => true,
				'sanitize_callback' => 'input_cleaner'
			],
			'lastname' => [
				'required' => true,
				'sanitize_callback' => 'input_cleaner'
			],
			'firstname' => [
				'required' => true,
				'sanitize_callback' => 'input_cleaner'
			]
		]
	]);
}

function gather_register_webhook($request) {
	$email = $request->get_param('email');
	$country = $request->get_param('country');
	$lastname = $request->get_param('lastname');
	$firstname = $request->get_param('firstname');

	$data = apply_filters('gather-register', $firstname, $lastname, $email, $country);
	if ($data['status'] !== 'success') {
		return new WP_Error('invalid', $data['msg'], array( 'status' => 400 ));
	}
	
	$body = [
		'status' => 'success',
		'msg' => $data['msg']
	];
	$response = new WP_REST_Response($body);
	$response->set_status( 201 );
	return $response;
}