<?php

if ( get_option('pdf-builder-dompdf-installed', false) == 'composer' ) {
	require 'vendor/autoload.php';
} else if ( get_option('pdf-builder-dompdf-installed', false) == 'curl' ) {
	require_once 'dompdf/autoload.inc.php';
}

use Dompdf\Dompdf;
use Dompdf\Options;

function render_pdf_from_html($html) {
	$options = new Options();
	$options->set('isRemoteEnabled', TRUE);
	$options->setIsHtml5ParserEnabled(true);
	$dompdf = new Dompdf($options);
	$dompdf->loadHtml($html);
	$dompdf->setPaper(array( 0 , 0 , 595 , 842 ));
	$dompdf->render();
	return $dompdf;
}

function new_render_pdf_from_html($html) {
	$tmp = get_temp_dir();
	$dompdf = new Dompdf([
		'logOutputFile' => '',
	    'isRemoteEnabled' => true,
	    'fontDir' => $tmp,
	    'fontCache' => $tmp,
	    'tempDir' => $tmp,
	    'chroot' => $tmp,
	]);
	$dompdf->loadHtml($html);
	$dompdf->setPaper('A4', 'portrait');
	$dompdf->render();
	return $dompdf;
}

function create_html_document_from_body($body, $css_link) {
	$html = "<!DOCTYPE html><html><head>";
	$html.= "<title>Resume</title>";
	$html.= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />";
	$html.= "<style>body,div,html,p,table,tbody,td,th,tr{margin:0;padding:0;border-spacing:0}ul{margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0}</style>";
	$html.= "<link href=\"${css_link}\" rel=\"stylesheet\">";
	$html.= "</head><body>";
	$html.= $body;
	$html.= "</body></html>";
	return $html;
}

function create_html_document_from_body_v3($body) {
	$html = "<!DOCTYPE html><html><head>";
	$html.= "<title>Resume</title>";
	$html.= "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />";
	$html.= "<style>body,div,html,p,table,tbody,td,th,tr{margin:0;padding:0;border-spacing:0}ul{margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0}</style>";
	$html.= "</head><body>";
	$html.= $body;
	$html.= "</body></html>";
	return $html;
}

function create_file_from_render($dompdf) {
	$output = $dompdf->output();
    return create_file_from_output($output);
}

function create_file_from_output($output) {
	$month  = date('m');
	$year  = date('Y');
	$day = date('d');
	$pdf_builder_dir = 'wp-content/uploads/pdf-builder';
	$year_dir = $pdf_builder_dir .'/'. $year ;
	$month_dir = $year_dir .'/'. $month;
	$dir = $month_dir .'/'. $day;

	if ( !is_dir($pdf_builder_dir) ) {
		mkdir($pdf_builder_dir);
	}
	if ( !is_dir($year_dir) ) {
		mkdir($year_dir);
	}
	if ( !is_dir($month_dir) ) {
		mkdir($month_dir);
	}
	if ( !is_dir($dir) ) {
		mkdir($dir);
	}

	$filename = "";
	$cookie_name = 'pdf-builder-uniqueID';
	if( isset($_COOKIE[$cookie_name]) ) {
		$filename = $_COOKIE[$cookie_name];
	} else {
		$filename = uniqid();
	}
	$filename .= '.pdf';

	if ( file_exists($dir . '/'. $filename) ) {
		unlink($dir . '/'. $filename);
	}

	file_put_contents($dir . '/'. $filename, $output);
	return get_site_url() .'/'. $dir . '/'. $filename;
}

function emptyCvUploadDirectory() {
	$files = glob('wp-content/uploads/pdf-builder/*');
	foreach($files as $file){
		if(is_file($file)) {
			unlink($file);
		}
	}
}