<?php

const DOMPDF_GIT = "https://github.com/dompdf/dompdf/releases/download/v2.0.1/";
const DOMPDF_FILE = "dompdf-2.0.1.zip";

function check_dompdf_is_installed() {
	if ( !get_option('pdf-builder-dompdf-installed', false) ) {
		install_dompdf();
	}
}

function install_dompdf() {
	$dir = dirname( __FILE__ );
	$zipfile_name = DOMPDF_FILE;
	$zipfile_url = DOMPDF_GIT.$zipfile_name;

	$resu = shell_exec('composer -V');
	if ( preg_match('/^Composer version \d\.\d\.\d \d{4}(-\d{2}){2} \d{2}(:\d{2}){2}/', $resu) == 1 ) {
		$current_directory = getcwd();
		chdir($dir);
		$result = shell_exec('composer require dompdf/dompdf;');
		chdir($current_directory);
		if ( is_dir(dirname( __FILE__ ).'/vendor') )
			update_option('pdf-builder-dompdf-installed', 'composer');
	} else {
		copy('https://getcomposer.org/installer', $dir . '/composer-setup.php');
		if ( hash_file('sha384', $dir . '/composer-setup.php') === '55ce33d7678c5a611085589f1f3ddf8b3c52d662cd01d4ba75c0ee0459970c2200a51f492d557530c71c15d8dba01eae') {
			$current_directory = getcwd();
			chdir($dir);
			$output = shell_exec('php composer-setup.php;');
			unlink($dir . '/composer-setup.php');
			$output = shell_exec('php composer.phar require dompdf/dompdf;');
			chdir($current_directory);
			if ( is_dir(dirname( __FILE__ ) . '/vendor') )
				update_option('pdf-builder-dompdf-installed', 'composer');
		}

		if ( !get_option('pdf-builder-dompdf-installed', false) ) {
			$current_directory = getcwd();
			chdir($dir);
			$output = shell_exec('curl -LO '.$zipfile_url.';');
			$output = shell_exec('unzip '.$zipfile_name.';');
			$output = shell_exec('unlink '.$zipfile_name.';');
			chdir($current_directory);
			if ( is_dir(dirname( __FILE__ ) . '/dompdf') )
				update_option('pdf-builder-dompdf-installed', 'curl');
		}
	}
}