<?php

/**
 * Return the json data
 * @param 
 * @return array The json data
 */
function read_json_data($path) {
	$content = file_get_contents($path);
	$data = json_decode($content, true);
	return $data;
}

function get_json_data($path) {
	$data = get_option($path, false);
	if ( $data !== false )
		return $data;

	$data = read_json_data($path);
	update_option($path, $data);
	return $data;
}

function read_all_json_files($dir) {
	$files = [];
	foreach ($dir as $fileinfo) {
		if (!$fileinfo->isDot()) {
			$data_name = str_replace('.json', '', $fileinfo->getFilename());
			$files[$data_name] = get_json_data($fileinfo->getPathname());
		}
	}
	return $files;
}

function create_form_json($folder) {
	$dir = new DirectoryIterator(dirname(__FILE__) . '/templates/'.$folder.'/json/');
	$files = read_all_json_files($dir);
	$var = json_encode($files['form']);
	foreach ($files as $key => $value) {
		if ($key == 'form')
			continue;
		$search = '"pdf_builder.'.$key.'"';
		$replace = json_encode($value);
		$var = str_replace($search, $replace, $var);
	}
	return json_decode($var, true);
}

function convert_image_to_base64($path) {
	$extension = pathinfo($path, PATHINFO_EXTENSION);
	$data = file_get_contents($path);
	$base64 = 'data:image/' . $extension . ';base64,' . base64_encode($data);
	return $base64;
}