<?php

require_once dirname( __FILE__ ) .'/templates/resume/resume.php';

function register_pdf_builder_routes() {
	register_rest_route('pdf-builder', '/create/resume', array(
		'methods' => 'POST',
		'callback' => 'create_resume',
		'permission_callback' => function($request){ return true; }
	));
	register_rest_route('pdf-builder', '/form/resume', array(
		'methods' => 'GET',
		'callback' => 'get_form_resume',
		'permission_callback' => function($request){ return true; }
	));
	register_rest_route('pdf-builder', '/v2/create/resume', array(
		'methods' => 'POST',
		'callback' => 'new_create_resume',
		'permission_callback' => function($request){ return true; }
	));
	register_rest_route('pdf-builder', '/v3/create/resume', array(
		'methods' => 'POST',
		'callback' => 'create_resume_v3',
		'permission_callback' => function($request){ return true; }
	));
}

function create_resume($request) {
	$firstname = $request->get_param('firstname');
	$lastname = $request->get_param('lastname');
	$file_name = 'Resume'.$firstname.$lastname;

	$html = create_resume_html($request);
	$dompdf = render_pdf_from_html($html);
	$file = create_file_from_render($dompdf);
	$data = ['url' => $file, 'file_name' => $file_name];

	$response = new WP_REST_Response($data);
	$response->set_status( 201 );
	return $response;
}

function get_form_resume() {
	$data = create_form_json('resume');
	$response = new WP_REST_Response($data);
	$response->set_status( 201 );
	return $response;
}

function new_create_resume($request) {
	$body = $request->get_param('html');
	$data = $request->get_param('data');
	$colors = $request->get_param('colors');
	$css = $request->get_param('css');

	$domain = parse_url($_SERVER['HTTP_HOST'], PHP_URL_HOST);
	if (!array_key_exists('firstname', $data))
		$data['firstname'] = '';
	if (!array_key_exists('lastname', $data))
		$data['lastname'] = '';
	$file_name = 'Resume'.$data['firstname'].$data['lastname'];
	$html = create_html_document_from_body($body, $css);

	$dompdf = new_render_pdf_from_html($html);
	$file = create_file_from_render($dompdf);
	$return = ['url' => $file, 'file_name' => $file_name];

	$content = '<!-- wp:html -->'. $body. '<!-- /wp:html -->';
	create_document_post($domain, $file_name, $data, $content);

	$response = new WP_REST_Response($return);
	$response->set_status( 201 );
	return $response;
}

function create_resume_v3($request) {
	$body = $request->get_param('html');
	$data = $request->get_param('data');
	$colors = $request->get_param('colors');

	$domain = parse_url($_SERVER['HTTP_HOST'], PHP_URL_HOST);
	if (!array_key_exists('firstname', $data))
		$data['firstname'] = '';
	if (!array_key_exists('lastname', $data))
		$data['lastname'] = '';
	$file_name = 'Resume'.$data['firstname'].$data['lastname'];
	$html = create_html_document_from_body_v3($body);

	$dompdf = new_render_pdf_from_html($html);
	$file = create_file_from_render($dompdf);
	$return = ['url' => $file, 'file_name' => $file_name];

	$content = "<!-- wp:html --><div width=\"100%\">${body}</div><iframe width=\"100%\" src=\"".$file."\"></iframe><!-- /wp:html -->";
	create_document_post($domain, $data['firstname'] . ' ' .$data['lastname'], $data, $content);

	$response = new WP_REST_Response($return);
	$response->set_status( 201 );
	return $response;
}