<?php
$width = 595;
$height = 842;
$font_size = 12;

function count_lines_description($description) {
	$count = 1;
	$n = 0;
	$arr = explode(' ', $description);
	foreach ($arr as $word) {
		$l = strlen($word);
		if ( $l + $n + 1 > 83) {
			$count += 1;
			$n = $l;
		} else {
			$n += $l + 1;
		}
	}
	return $count;
}

function count_lines_education($education) {
	$count = 0;
	$things = ['thing1', 'thing2', 'thing3'];
	foreach ($education as $obj) {
		// formation line
		$count += 1;
		foreach ($things as $thing) {
			$n = strlen($obj[$thing]);
			if ( $n > 74 ) {
				$count += 2;
			} else {
				$count += 1;
			}
		}
	}
	return $count;
}

function count_lines_work($work) {
	$count = 0;
	$things = ['thing1', 'thing2', 'thing3'];
	foreach ($work as $obj) {
		$n = strlen($obj['organisation']);
		if ( $n > 67 ) {
			$count += 2;
		} else {
			$count += 1;
		}
		foreach ($things as $thing) {
			$n = strlen($obj[$thing]);
			if ( $n > 74 ) {
				$count += 2;
			} else {
				$count += 1;
			}
		}
	}
	return $count;
}

function count_lines_hobbies($hobbies) {
	return count($hobbies);
}

function count_lines_languages($languages) {
	return count($languages);
}

function count_lines_skills($softskills, $softwareskills) {
	return count($softwareskills) + count($softskills);
}

if (count($this->education) + count($this->work) >= 4 ) {
	$w = count_lines_work($this->work) . ' ';
	$e = count_lines_education($this->education) . ' ';
	$l = count_lines_languages($this->languages) . ' ';
	$s = count_lines_skills($this->softskills, $this->softwareskills) . ' ';
	$h = count_lines_hobbies($this->hobby) . ' ';
	$d = count_lines_description($this->description) . ' ';
	$n = $w + $e + $l + $s + $h + $d;
	if ( $n > 42 ) {
		if ( (count($this->education) + count($this->work)) == 6) {
			$font_size = 10.25;
		} else if ( (count($this->education) + count($this->work)) == 5) {
			$font_size = 10.5;
		} else if ( (count($this->education) + count($this->work)) == 4) {
			$font_size = 11.25;
		}
	}
}

?>
<style type="text/css">
	* {
		margin: 0;
		padding: 0;
		font-size: <?php echo $font_size;?>pt;
		font-weight: normal;
	}

	table {
		width: 100%;
		border-spacing : 0;
		border-collapse : collapse;
	}

	td, th {
		vertical-align: top;
	}

	td.middle, th.middle {
		vertical-align: middle;
	}

	td.top, th.top {
		vertical-align: top;
	}

	td.bottom, th.bottom {
		vertical-align: bottom;
	}

	.page {
		height: 842pt;
		width: 595pt;
		overflow: hidden;
		font-family: "Helvetica";
	}

	.page table {
		position: relative;
		z-index: 2;
	}

	.aside {
		z-index: 0;
		position: absolute;
		width: 36%;
		height: 842pt;
		background-color: <?php echo $this->color;?>;
	}

	.initials {
		font-size: <?php echo (5 * $font_size);?>pt;
	}

	.name {
		letter-spacing: 2px;
		font-weight: 600;
		font-size: <?php echo (2.5 * $font_size);?>pt;
		color: <?php echo $this->color;?>;
	}

	.section-title {
		color: <?php echo $this->color;?>;
	}

	.element-title, .element-info, .element-paragraph {
		color: #8a9898;
	}

	.left .element-title, .left .element-info, .left .element-paragraph {
		color:  white;
	}

	.element-title {
		font-weight: 500;
		font-size:  <?php echo $font_size;?>pt;
	}

	.element-info {
		font-weight: normal;
		font-size:  <?php echo (0.9 * $font_size);?>pt;
	}

	.element-paragraph {
		font-size: <?php echo (0.8 * $font_size);?>pt;
	}

	.left .section-title, .left .element-title, .left .list , .left .element-info, .left .intro {
		padding-left: 4%;
		padding-right: 4%;
	}

	.right .section-title, .right .element-title, .right .element-info, .right .intro, .right .description, .right .hobbies, .right .cell {
		padding-right: 4%;
		padding-left: 4%;
	}

	.right ul.list {
		padding-left: 30pt;
		padding-right: 8%;
	}

	.right {
		text-align: left;
	}

	.left {
		width: 36%;
		color: white;
		text-align: right;
	}

	.rating-section {
		display: inline-block;
		width: 55pt;
	}

	.rate p {
		display: inline-block;
		width:  150pt;
	}

	.level-circle {
		display: inline-block;
		margin-left: 1pt;
		margin-right: 1pt;
		width: 5pt;
		height: 5pt;
		border: 1px solid #8a9898;
		border-radius: 5%;
	}

	.level-circle.full {
		background-color: #8a9898;
	}

	.white-rect {
		position: relative;
		width: 100%;
		height: 10pt;
		margin-right: 4%;
		margin-left: 75%;
		background-color: white;
	}

	.section-separator {
		width: 100%;
		height: 10pt;
	}

	.cell {
		width: 50%;
		display: inline-block;
	}

	div.cell {
		padding-top: 5pt;
	}

	.img-link {
		position: fixed;
		width: 50pt;
		bottom: 40pt;
		right: 5pt;
	}

	img.logo {
		width: 50pt;
	}
</style>
<div class="page">
	<div class="aside"></div>
	<table>
		<tbody>
			<tr>
				<td class="left middle">
					<div class="intro">
						<p class="initials"><?php echo strtoupper(substr($this->firstname,0,1).substr($this->lastname,0,1)); ?></p>
					</div>
				</td>
				<td class="right middle">
					<div class="intro">
						<p class="name"><?php echo $this->firstname . ' ' . $this->lastname; ?></p>
					</div>
				</td>
			</tr>
			<tr>
				<th class="left middle"><div class="white-rect"></div></th>
				<th class="right middle"><p class="section-title">PROFILE</p></th>
			</tr>
			<tr>
				<td class="left"><p class="element-info"></p></td>
				<td class="right">
					<div class="description"><p class="element-paragraph"><?php echo $this->description; ?></p></div>
					<div class="section-separator"></div>
				</td>
			</tr>



			<tr>
				<th class="left middle"><div class="white-rect"></div></th>
				<th class="right middle"><p class="section-title">EDUCATION</p></th>
			</tr>
			<?php for ($i = 0; $i < count($this->education); $i++) { ?>
			<tr>
				<td class="left">
					<p class="element-title">
						<?php echo $this->education[$i]['organisation']; ?>
					</p>
						<p class="element-info"><?php echo $this->education[$i]['date']['start'] . ' - ' . $this->education[$i]['date']['end']; ?></p>
				</td>
				<td class="right">
					<p class="element-title"><?php echo $this->education[$i]['formation']; ?></p>
					<ul class="list">
						<li class="element-paragraph"><?php echo $this->education[$i]['thing1']; ?></li>
						<li class="element-paragraph"><?php echo $this->education[$i]['thing2']; ?></li>
						<li class="element-paragraph"><?php echo $this->education[$i]['thing3']; ?></li>
					</ul>
					<div class="section-separator"></div>
					<?php if ($i + 1 >= count($this->education) ) { ?>
					<div class="section-separator"></div>
					<?php } ?>
				</td>
			</tr>
			<?php } ?>


			<tr>
				<th class="left middle"><div class="white-rect"></div></th>
				<th class="right middle"><p class="section-title">EXPERIENCE</p></th>
			</tr>
			<?php for ($i = 0; $i < count($this->work); $i++) { ?>
			<tr>
				<td class="left">
					<p class="element-title"><?php echo $this->work[$i]['position']; ?></p>
					<p class="element-info"><?php echo $this->work[$i]['date']['start'] . ' - ' . $this->work[$i]['date']['end']; ?></p>
				</td>
				<td class="right">
					<p class="element-title"><?php echo $this->work[$i]['organisation']; ?></p>
					<ul class="list">
						<li class="element-paragraph"><?php echo $this->work[$i]['thing1']; ?></li>
						<li class="element-paragraph"><?php echo $this->work[$i]['thing2']; ?></li>
						<li class="element-paragraph"><?php echo $this->work[$i]['thing3']; ?></li>
					</ul>
					<div class="section-separator"></div>
					<?php if ($i + 1 >= count($this->work) ) { ?>
					<div class="section-separator"></div>
					<?php } ?>
				</td>
			</tr>
			<?php } ?>


			<tr>
				<td class="left middle"><div class="white-rect"></div></td>
				<td class="right middle"><p class="section-title">SKILLS</p></td>
			</tr>
			<tr>
				<td class="left"></td>
				<td class="right">
					<?php for ( $i = 0; $i < count($this->softskills); $i++ ) { ?>
					<div class="rate">
						<p class="element-info"><?php echo $this->softskills[$i]['softskill']; ?></p>
						<div class="rating-section">
							<?php for ($j=0;$j<5;$j++) {
								if ($j < $this->softskills[$i]['level']) { 
									echo '<div class="level-circle full"></div>';
								} else {
									echo '<div class="level-circle"></div>';
								}
							} ?>
						</div>
					</div>
					<?php }
					for ( $i = 0; $i < count($this->softwareskills); $i++ ) { ?>
					<div class="rate">
						<p class="element-info"><?php echo $this->softwareskills[$i]['softwareskill']; ?></p>
						<div class="rating-section">
							<?php for ($j=0;$j<5;$j++) {
								if ($j < $this->softwareskills[$i]['level']) { 
									echo '<div class="level-circle full"></div>';
								} else {
									echo '<div class="level-circle"></div>';
								}
							} ?>
						</div>
					</div>
					<?php } ?>
					<div class="section-separator"></div>
					<div class="section-separator"></div>
				</td>
			</tr>



			<tr>
				<td class="left middle"><div class="white-rect"></div></td>
				<td class="right middle">
					<p class="section-title cell">LANGUAGES</p>
					<p class="section-title cell">CONTACT</p>
				</td>
			</tr>
			<tr>
				<td class="left"></td>
				<td class="right">
					<div class="cell">
						<?php for ( $i = 0; $i < count($this->languages); $i++ ) { ?>
						<p class="element-info"><?php echo $this->languages[$i]['language'].' '.$this->languages[$i]['level']; ?></p>
						<?php } ?>
					</div>
					<div class="cell">
						<p class="element-info"><?php echo $this->email; ?></p>
						<p class="element-info"><?php echo $this->nationality; ?></p>
						<p class="element-info"><?php echo $this->phone; ?></p>
					</div>
					<div class="section-separator"></div>
					<div class="section-separator"></div>
				</td>
			</tr>


			<tr>
				<td class="left middle"><div class="white-rect"></div></td>
				<td class="right middle"><p class="section-title">HOBBIES</p></td>
			</tr>
			<tr>
				<td class="left"></td>
				<td class="right">
					<div class="hobbies">
						<?php for ( $i = 0; $i < count($this->hobby); $i++ )  { ?>
						<p class="element-paragraph"><?php echo $this->hobby[$i]['hobby']; ?></p>
						<?php } ?>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
	<a href="https://www.cvplugin.com/" target="_blank" class="img-link">
		<img src="<?php echo convert_image_to_base64(dirname(__FILE__) . '/images/logo.png'); ?>" class="logo">
	</a>
</div>