<?php
$width = 595;
$height = 842;
$font_size = 14;

if ( (count($this->education) + count($this->work)) == 6) {
	$font_size = 10.25;
} else if ( (count($this->education) + count($this->work)) == 5) {
	$font_size = 11.75;
} else if ( (count($this->education) + count($this->work)) == 4) {
	$font_size = 13;
}
?>
<style type="text/css">
	* {
		margin: 0;
		padding: 0;
		color:  #444440;
		font-size: <?php echo $font_size;?>pt;
		font-weight: normal;
	}

	table {
		width: 100%;
		border-spacing : 0;
		border-collapse : collapse;
	}

	td, th {
		vertical-align: middle;
	}

	.page {
		height: 842pt;
		width: 595pt;
		overflow: hidden;
		font-family: "Helvetica";
	}

	.page table {
		position: relative;
		z-index: 2;
	}

	.page table tr {
		height: 842pt;
	}

	.aside {
		z-index: 0;
		position: absolute;
		width: 2.5%;
		height: 842pt;
		background-color: <?php echo $this->color;?>;
	}

	.column {
		width: 50%;
	}

	.intro {
		padding-top: 10%;
		padding-bottom: 10%;
	}

	.name {
		text-align: center;
		letter-spacing: 2px;
		font-weight: 600;
		font-size: <?php echo (1.2 * $font_size);?>pt;
		color: <?php echo $this->color;?>;
	}

	.picture {
		width: 80pt;
		height: 80pt;
		overflow: hidden;
		border: 7.5px solid #eff0f2;
		margin-left: auto;
		margin-right: auto;
	}

	.picture img {
		width: 100%;
	}

	.left .content {
		padding-left: 10%;
		padding-right: 5%;
	}

	.right .content {
		padding-left: 5%;
		padding-right: 10%;
	}

	.section-title {
		color: <?php echo $this->color;?>;
		padding-top: 5pt;
		padding-bottom: 5pt;
		border-width: 2px 0 2px 0;
		border-color: #e1e1e1;
		border-style: solid;
	}

	.rating-section {
		display: inline-block;
		width: 55pt;
	}

	.rate p {
		display: inline-block;
		width:  150pt;
	}

	.level-circle {
		display: inline-block;
		margin-left: 1pt;
		margin-right: 1pt;
		width: 5pt;
		height: 5pt;
		border: 1px solid #8a9898;
		border-radius: 5%;
	}

	.level-circle.full {
		background-color: #8a9898;
	}

	.element {
		padding-left: 5%;
		padding-right: 5%;
		padding-top: 7pt;
	}

	.element-title {
		color:  black;
		font-weight: 500;
		font-size:  <?php echo $font_size;?>pt;
	}

	.element-info {
		font-weight: normal;
		font-size:  <?php echo (0.9 * $font_size);?>pt;
	}

	.element-paragraph {
		font-size: <?php echo (0.8 * $font_size);?>pt;
	}

	.element ul.list {
		padding-left: 5%;
		list-style-type: circle;
	}

	.section {
		padding-top: 5%;
	}

	.img-link {
		position: fixed;
		width: 50pt;
		bottom: 50pt;
		right: 40pt;
	}

	img.logo {
		width: 50pt;
	}
</style>
<div class="page">
	<div class="aside"></div>
	<table>
		<tbody>
			<tr>
				<td class="column left">
					<div class="intro">
						<div class="picture">
							<img src="<?php echo ($this->picture != null)? $this->picture: ''; ?>">
						</div>
						<p class="name"><?php echo strtoupper($this->firstname . ' ' . $this->lastname); ?></p>
					</div>


					<div class="content">
						<div class="section">
							<p class="section-title">PROFILE</p>
							<div class="element">
								<p class="element-paragraph"><?php echo $this->description; ?></p>
							</div>
						</div>

						<div class="section">
							<p class="section-title">REACH ME OUT</p>
							<div class="element">
								<p class="element-paragraph"><?php echo $this->email; ?></p>
								<p class="element-paragraph"><?php echo $this->nationality; ?></p>
								<p class="element-paragraph"><?php echo $this->phone; ?></p>
							</div>
						</div>

						<div class="section">
							<p class="section-title">SKILLS</p>
							<div class="element">
								<?php for ( $i = 0; $i < count($this->softskills); $i++ ) { ?>
								<div class="rate">
									<p class="element-paragraph"><?php echo $this->softskills[$i]['softskill']; ?></p>
									<div class="rating-section">
									<?php for ($j=0;$j<5;$j++) {
										if ($j < $this->softskills[$i]['level']) { 
											echo '<div class="level-circle full"></div>';
										} else {
											echo '<div class="level-circle"></div>';
										}
									} ?>
									</div>
								</div>
								<?php }
								for ( $i = 0; $i < count($this->softwareskills); $i++ ) { ?>
								<div class="rate">
									<p class="element-paragraph"><?php echo $this->softwareskills[$i]['softwareskill']; ?></p>
									<div class="rating-section">
										<?php for ($j=0;$j<5;$j++) {
											if ($j < $this->softwareskills[$i]['level']) { 
												echo '<div class="level-circle full"></div>';
											} else {
												echo '<div class="level-circle"></div>';
											}
										} ?>
									</div>
								</div>
								<?php } ?>
							</div>
						</div>


						<div class="section">
							<p class="section-title">LANGUAGES</p>
							<div class="element">
								<?php for ( $i = 0; $i < count($this->languages); $i++ ) { ?>
								<p class="element-paragraph"><?php echo $this->languages[$i]['language'].' '.$this->languages[$i]['level']; ?></p>
								<?php } ?>
							</div>
						</div>
					</div>
				</td>
				<td class="column right">
					<div class="content">
						<div class="section">
							<p class="section-title">ACADEMIC HISTORY</p>
							<?php for ($i = 0; $i < count($this->education); $i++) { ?>
							<div class="element">
								<p class="element-title">
									<?php echo $this->education[$i]['organisation']; ?>
								</p>
								<p class="element-info">
									<?php echo $this->education[$i]['formation'].' | '; ?><?php echo $this->education[$i]['date']['start'] . ' - ' . $this->education[$i]['date']['end']; ?>
								</p>
								<ul class="list">
									<li class="element-paragraph"><?php echo $this->education[$i]['thing1']; ?></li>
									<li class="element-paragraph"><?php echo $this->education[$i]['thing2']; ?></li>
									<li class="element-paragraph"><?php echo $this->education[$i]['thing3']; ?></li>
								</ul>
							</div>
							<?php } ?>
						</div>

						<div class="section">
							<p class="section-title">CAREER HISTORY</p>
							<?php for ($i = 0; $i < count($this->work); $i++) { ?>
							<div class="element">
								<p class="element-title">
									<?php echo $this->work[$i]['position']; ?>
								</p>
								<p class="element-info">
									<?php echo $this->work[$i]['organisation'].' | '; ?><?php echo $this->work[$i]['date']['start'] . ' - ' . $this->work[$i]['date']['end']; ?>
								</p>
								<ul class="list">
									<li class="element-paragraph"><?php echo $this->work[$i]['thing1']; ?></li>
									<li class="element-paragraph"><?php echo $this->work[$i]['thing2']; ?></li>
									<li class="element-paragraph"><?php echo $this->work[$i]['thing3']; ?></li>
								</ul>
							</div>
							<?php } ?>
						</div>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
	<a href="https://www.cvplugin.com/" target="_blank" class="img-link">
		<img src="<?php echo convert_image_to_base64(dirname(__FILE__) . '/images/logo.png'); ?>" class="logo">
	</a>
</div>