<?php
$width = 595;
$height = 842;
switch (count($this->education)) {
	case 3:
		$margin = array(0, 0);
		break;
	case 2:
	default:
		$margin = array(0, 29.75);
		break;
}

$width = $width - 2 * $margin[1];
$height = $height  - 2 * $margin[0];
?>
<style type="text/css">
	* {
		margin: 0;
		padding: 0;
		font-size: 12pt;
		font-weight: normal;
		box-sizing: border-box;
	}

	table {
		width: 100%;
		border-spacing : 0;
		border-collapse : collapse;
	}

	td, th {
		vertical-align: top;
	}

	.page {
		<?php
		$margin_w = $margin[1];
		$margin_h = $margin[0];
		$unit_w = '';
		$unit_h = '';
		if ( $margin_w != 0) {
			$unit_w = 'pt';
		}
		if ( $margin_h != 0) {
			$unit_h = 'pt';
		}
		echo "width: ".$width."pt;";
		echo "height: ".$height."pt;";
		echo "margin-left: ".$margin_w.$unit_w.";";
		echo "margin-right: ".$margin_w.$unit_w.";";
		echo "margin-top: ".$margin_h.$unit_h.";";
		echo "margin-bottom: ".$margin_h.$unit_h.";";
		?>
		position: relative;
		overflow: hidden;
	}

	.profile {
		width: 100%;
		height: 7.3%;
		padding-top: 2%;
		border-bottom: 2px solid black;
	}

	.description {
		width: 100%;
		height: 9.5%;
		text-align: center;
	}

	.content {
		width: 100%;
		height: 69.5%;
	}

	.footer {
		width: 100%;
		height: 9.5%;
	}

	.fullname, .contact {
		width: 50%;
		text-align: center;
	}

	.title {
		text-align: center;
		font-weight: 400;
		color:  <?php echo $this->color; ?>;
		font-size: 30pt;
	}

	.info {
		font-weight: 300;
		letter-spacing: 1px;
	}

	.section-title {
		font-weight: 400;
        letter-spacing: 2px;
        color: <?php echo $this->color; ?>;
	}

	.text {
		font-size: 10.5pt;
		padding-left: 5%;
		padding-right: 5%;
	}

	.content {
		text-align: center;
	}

	.content th, .table-header {
		border-top: 2px solid black;
		border-bottom: 2px solid black;
	}

	.content .left {
		width: 50%;
		border-right: 2px solid black;
	}

	.content .right {
		width: 50%;
		border-left: 2px solid black;
	}

	.element-title {
		font-weight: 400;
		font-size: 13pt;
		margin: 1% 0 0 0;
	}

	.element-subtitle {
		color: <?php echo $this->color; ?>;
		font-weight: 400;
		font-size: 12.5pt;
		margin: 0;
	}

	.element-info {
		font-weight: 400;
		font-size: 11pt;
		margin: 0 0 0.5% 0;
	}

	.element-text {
		font-size: 9.5pt;
		margin-top: 0.5%;
		margin-bottom: 0.5%;
	}

	.languages {
		height: 12%;
	}

	.education {
		height: 44%;
	}

	.skills {
		height: 35%;
		border-bottom: 1px solid blue;
	}

	.rating-section {
		width: 100%;
		height: 15pt;
	}

	.rating {
		margin-left: 70%;
		margin-top: -9.8pt;
		position: absolute;
	}

	.level-circle {
		margin-left: 1pt;
		margin-right: 1pt;
		display: inline-block;
		width: 5pt;
		height: 5pt;
		border: 1px solid black;
		border-radius: 5%;
	}

	.level-circle.full {
		background-color: black;
	}

	.hobbies {
		width: 100%;
		text-align: center;
		border-top: 2px solid black;
	}

	.hobbies .element-info {
		padding-right: 5%;
	}

	.img-link {
		position: fixed;
		width: 50pt;
		bottom: 50pt;
		right: 40pt;
	}

	img.logo {
		width: 50pt;
	}
</style>
<div class="page">
	<div class="profile">
		<table>
			<tr>
				<th class="fullname title">
					<?php echo $this->firstname . ' ' . $this->lastname; ?>
				</th>
				<th class="contact">
					<p class="info"><?php echo $this->email; ?></p>
					<p class="info"><?php echo $this->nationality; ?></p>
					<p class="info"><?php echo $this->phone; ?></p>
				</th>
			</tr>
		</table>
	</div>
	<div class="description">
		<h3 class="section-title">PERSONAL PROFILE</h3>
		<p class="text"><?php echo $this->description; ?></p>
	</div>
	<table class="content">
		<tr>
			<th class="section-title left">EXPERIENCE</th>
			<th class="section-title right">EDUCATION</th>
		</tr>
		<tr class="work-edu">
			<td class="left">
				<?php for ($i = 0; $i < count($this->work); $i++) { ?>
				<div class="element">
					<h3 class="element-title"><?php echo $this->work[$i]['position']; ?></h3>
					<h4 class="element-subtitle"><?php echo $this->work[$i]['organisation']; ?></h4>
					<h5 class="element-info"><?php echo $this->work[$i]['date']['start']; ?> - <?php echo $this->work[$i]['date']['end']; ?></h5>
					<p class="element-text"><?php echo $this->work[$i]['thing1']; ?> | <?php echo $this->work[$i]['thing2']; ?> | <?php echo $this->work[$i]['thing3']; ?></p>
				</div>
				<?php } ?>
			</td>
			<td class="right">
				<div class="education">
					<?php for ($i = 0; $i < count($this->education); $i++) { ?>
					<div class="element">
						<h3 class="element-title"><?php echo $this->education[$i]['organisation']; ?></h3>
						<h4 class="element-subtitle"><?php echo $this->education[$i]['formation']; ?></h4>
						<h5 class="element-info"><?php echo $this->education[$i]['date']['start']; ?> - <?php echo $this->education[$i]['date']['end']; ?></h5>
						<p class="element-text"><?php echo $this->education[$i]['thing1']; ?> | <?php echo $this->education[$i]['thing2']; ?> | <?php echo $this->education[$i]['thing3']; ?></p>
					</div>
					<?php } ?>
				</div>

				<div class="languages">
					<p class="section-title table-header">LANGUAGES</p>
					<div class="element">
						<?php for ( $i = 0; $i < count($this->languages); $i++ ) { ?>
						<p class="element-text"><?php echo $this->languages[$i]['language']; ?> <?php echo $this->languages[$i]['level']; ?></p>
						<?php } ?>
					</div>
				</div>
			</td>
		</tr>
		<tr>
			<th class="section-title left">SOFTSKILLS</th>
			<th class="section-title right">IT SKILLS</th>
		</tr>
		<tr class="skills">
			<td class="left">
				<div class="element">
					<?php for ( $i = 0; $i < count($this->softskills); $i++ ) { ?>
					<div class="rating-section">
						<p class="element-text rating-label"><?php echo $this->softskills[$i]['softskill']; ?></p>
						<div class="rating">
						<?php for ($j=0;$j<5;$j++) {
							if ($j < $this->softskills[$i]['level']) { 
								echo '<div class="level-circle full"></div>';
							} else {
								echo '<div class="level-circle empty"></div>';
							}
						} ?>
						</div>
					</div>
					<?php } ?>
				</div>
			</td>
			<td class="right">
				<div class="element">
					<?php for ( $i = 0; $i < count($this->softwareskills); $i++ ) { ?>
					<div class="rating-section">
						<p class="element-text rating-label"><?php echo $this->softwareskills[$i]['softwareskill']; ?></p>
						<div class="rating">
						<?php for ($j=0;$j<5;$j++) {
							if ($j < $this->softwareskills[$i]['level']) { 
								echo '<div class="level-circle full"></div>';
							} else {
								echo '<div class="level-circle empty"></div>';
							}
						} ?>
						</div>
					</div>
					<?php } ?>
				</div>
			</td>
		</tr>
	</table>
	<div class="footer">
		<div class="element hobbies">
			<h2 class="section-title">HOBBIES</h2>
			<p class="text">
				<?php for ( $i = 0; $i < count($this->hobby); $i++ )  {
					echo $this->hobby[$i]['hobby'];
					if ( $i + 1 < count($this->hobby)) {
						echo '<span> | </span>';
					}
				} ?>
			</p>
		</div>
	</div>
	<a href="https://www.cvplugin.com/" target="_blank" class="img-link">
		<img src="<?php echo convert_image_to_base64(dirname(__FILE__) . '/images/logo.png'); ?>" class="logo">
	</a>
</div>